<?php
/**
 * Scripts
 *
 * @package     AutomatorWP\OpenAI\Scripts
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Register admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_openai_admin_register_scripts() {

    // Use minified libraries if SCRIPT_DEBUG is turned off
    $suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

    // Stylesheets
    wp_register_style( 'automatorwp-openai-css', AUTOMATORWP_OPENAI_URL . 'assets/css/automatorwp-openai' . $suffix . '.css', array(), AUTOMATORWP_OPENAI_VER, 'all' );

    // Scripts
    wp_register_script( 'automatorwp-openai-js', AUTOMATORWP_OPENAI_URL . 'assets/js/automatorwp-openai' . $suffix . '.js', array( 'jquery' ), AUTOMATORWP_OPENAI_VER, true );
    
}
add_action( 'admin_init', 'automatorwp_openai_admin_register_scripts' );

/**
 * Enqueue admin scripts
 *
 * @since       1.0.0
 * @return      void
 */
function automatorwp_openai_admin_enqueue_scripts( $hook ) {

    // Stylesheets
    wp_enqueue_style( 'automatorwp-openai-css' );

    wp_localize_script( 'automatorwp-openai-js', 'automatorwp_openai', array(
        'nonce' => automatorwp_get_admin_nonce(),
    ) );

    wp_enqueue_script( 'automatorwp-openai-js' );

}
add_action( 'admin_enqueue_scripts', 'automatorwp_openai_admin_enqueue_scripts', 100 );